#============================================================================== 
# ** Ruby.Array.math
#------------------------------------------------------------------------------
# Description:
# ------------
# More Mathematical methods for the Array class, these methods however assume
# all objects in the array are of class Numeric.
#  
# Method List:
# ------------
# average
# geometric_average
# product
# sum
#==============================================================================

MACL::Loaded << 'Ruby.Array.math'

#============================================================================== 
# ** Array     
#==============================================================================

class Array
  #---------------------------------------------------------------------------
  # * Name      : Average
  #   Info      : Averages all values in the array
  #   Author    : Trickster
  #   Call Info : Zero To One Arguments Defaults to False
  #               Boolean float if true always returns a Float else returns a
  #               Float or a Integer depending on the Types in the array
  #---------------------------------------------------------------------------
  def average(float = false)
    # Divide By Number
    return sum / (float ? size.to_f : size)
  end
  #---------------------------------------------------------------------------
  # * Name      : Geometric Average
  #   Info      : Returns the Geometric Mean of all values in the array
  #   Author    : Trickster
  #   Call Info : Zero To One Arguments Defaults to False
  #               Boolean to_float if true always returns a Float else 
  #               always returns an Integer regardless of the Types in the 
  #               array
  #---------------------------------------------------------------------------
  def geometric_average(float = false)
    # Return 0 if empty
    return 0 if empty?
    # Get Geometric Average
    average = product ** (1.0 / size)
    # If Float return average else convert to integer
    return (float ? average : average.to_i)
  end
  #---------------------------------------------------------------------------
  # * Name      : Product
  #   Info      : Returns the product of all values in the array
  #   Author    : Trickster
  #   Call Info : No Arguments
  #---------------------------------------------------------------------------
  def product
    # Setup N initialize to 1
    n = 1
    # Run Through and Find Product
    each {|num| n *= num}
    # Return Product
    return n
  end
  #---------------------------------------------------------------------------
  # * Name      : Sum
  #   Info      : Sums all values in the array
  #   Author    : Trickster
  #   Call Info : No Arguments
  #---------------------------------------------------------------------------
  def sum
    # Initialize local variable n
    n = 0
    # Sum Up Values in Array
    each {|num| n += num}
    # Return number
    return n
  end
end